/*
 * Decompiled with CFR 0.152.
 */
package com.helicontech.zoo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class JavaAppDeployer {
    private String appVirtualPath;
    private String appPhysicalPath;
    private String warFile;
    private String warUrl;
    private String packageUrl;
    private String packageExtractFolder;
    private final int PROGRESS_STEP_DOT = 0x100000;
    private final int PROGRESS_NUM_EVERY_DOT = 10;
    private int lastProgressPrint = 0;

    public static void main(String[] args) {
        JavaAppDeployer deployer = new JavaAppDeployer();
        try {
            deployer.go();
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private JavaAppDeployer() {
        this.getEnvs();
    }

    private void getEnvs() {
        this.appVirtualPath = System.getenv("APPL_VIRTUAL_PATH");
        this.appPhysicalPath = System.getenv("APPL_PHYSICAL_PATH");
        if (this.appVirtualPath == null) {
            this.appVirtualPath = "";
        }
        if (JavaAppDeployer.isNullOrEmpty(this.appPhysicalPath)) {
            throw new RuntimeException("APPL_PHYSICAL_PATH is empty");
        }
        this.warFile = System.getenv("WAR_FILE");
        this.warUrl = System.getenv("WAR_URL");
        this.packageUrl = System.getenv("PACKAGE_URL");
        this.packageExtractFolder = System.getenv("PACKAGE_EXTRACT_FOLDER");
    }

    private void go() throws IOException {
        if (!JavaAppDeployer.isNullOrEmpty(this.warFile)) {
            if (!this.fileExists(this.warFile)) {
                if (!JavaAppDeployer.isNullOrEmpty(this.warUrl)) {
                    try {
                        this.downloadFile(this.warUrl, new File(this.appPhysicalPath, this.warFile));
                    }
                    catch (IOException e) {
                        System.err.println("Download war file error: " + e.toString());
                        throw e;
                    }
                }
            } else {
                System.out.println("war file " + this.warFile + " already exists");
            }
        }
        if (!JavaAppDeployer.isNullOrEmpty(this.packageUrl)) {
            if (JavaAppDeployer.isNullOrEmpty(this.packageExtractFolder)) {
                throw new RuntimeException("PACKAGE_URL is set but PACKAGE_EXTRACT_FOLDER is not");
            }
            File targetFolder = new File(this.appPhysicalPath, this.packageExtractFolder);
            if (!targetFolder.exists()) {
                File downloadedPackage = new File(this.appPhysicalPath, this.getTempFilenameFOrUrl(this.packageUrl));
                try {
                    this.downloadFile(this.packageUrl, downloadedPackage);
                }
                catch (IOException e) {
                    System.err.println("Download package file error: " + e.toString());
                    throw e;
                }
                JavaAppDeployer.extractFolder(downloadedPackage, targetFolder);
                System.out.println("Deleting downloaded file");
                downloadedPackage.deleteOnExit();
            } else {
                System.out.println("Directory " + this.packageExtractFolder + " already exists, download & extract will be skipped");
            }
        }
        System.out.println("\nApplication is starting, please wait...");
    }

    private String getTempFilenameFOrUrl(String url) {
        return url.replace(":", "").replaceAll("[^-_\\w]+", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String sourceUrl, File file) throws IOException {
        this.resetProgress();
        System.out.println("Downloading " + sourceUrl);
        BufferedInputStream in = null;
        FileOutputStream fOut = null;
        int bufferSize = 0x100000;
        int total = 0;
        try {
            int count;
            URL url = new URL(sourceUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("Referer", "http://www.helicontech.com/zoo/");
            in = new BufferedInputStream(url.openStream());
            fOut = new FileOutputStream(file);
            byte[] data = new byte[bufferSize];
            while ((count = in.read(data, 0, bufferSize)) != -1) {
                fOut.write(data, 0, count);
                this.printProgress(total += count);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fOut != null) {
                fOut.close();
            }
        }
        System.out.printf("\nDownloaded %.1f Mb\n", (double)total / 1024.0 / 1024.0);
        System.out.println("Saved to " + file.getAbsolutePath());
    }

    private void resetProgress() {
        this.lastProgressPrint = 0;
    }

    private void printProgress(int bytesDownloaded) {
        int delta_dots = (bytesDownloaded - this.lastProgressPrint * 0x100000) / 0x100000;
        if (delta_dots > 0) {
            for (int i = 0; i < delta_dots; ++i) {
                System.out.print(".");
                ++this.lastProgressPrint;
                if (this.lastProgressPrint % 10 == 0) {
                    System.out.printf(" %d Mb\n", bytesDownloaded / 1024 / 1024);
                }
                System.out.flush();
            }
        }
    }

    private boolean fileExists(String pathInApp) {
        File file = new File(this.appPhysicalPath, pathInApp);
        return file.exists();
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static void extractFolder(File zipFile, File destFolder) throws ZipException, IOException {
        System.out.printf("Extracting %s to %s\n", zipFile.getName(), destFolder.getName());
        int BUFFER = 2048;
        ZipFile zip = new ZipFile(zipFile);
        destFolder.mkdir();
        Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
        while (zipFileEntries.hasMoreElements()) {
            int currentByte;
            ZipEntry entry = zipFileEntries.nextElement();
            String currentEntry = entry.getName();
            File destFile = new File(destFolder, currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (entry.isDirectory()) continue;
            BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
            byte[] data = new byte[BUFFER];
            FileOutputStream fos = new FileOutputStream(destFile);
            BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
            while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                dest.write(data, 0, currentByte);
            }
            dest.flush();
            dest.close();
            is.close();
        }
        zip.close();
    }
}

