/*
 * Decompiled with CFR 0.152.
 */
package com.helicontech.zoo;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class JavaAppDeployer {
    private String appVirtualPath;
    private String appPhysicalPath;
    private String warFile;
    private String warUrl;
    private final int PROGRESS_STEP_DOT = 0x100000;
    private final int PROGRESS_NUM_EVERY_DOT = 10;
    private int lastProgressPrint = 0;

    public static void main(String[] args) {
        JavaAppDeployer deployer = new JavaAppDeployer();
        try {
            deployer.go();
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private JavaAppDeployer() {
        this.getEnvs();
    }

    private void getEnvs() {
        this.appVirtualPath = System.getenv("APPL_VIRTUAL_PATH");
        this.appPhysicalPath = System.getenv("APPL_PHYSICAL_PATH");
        this.warFile = System.getenv("WAR_FILE");
        this.warUrl = System.getenv("WAR_URL");
        if (this.appVirtualPath == null) {
            this.appVirtualPath = "";
        }
        if (JavaAppDeployer.isNullOrEmpty(this.appPhysicalPath)) {
            throw new RuntimeException("APPL_PHYSICAL_PATH is empty");
        }
    }

    private void go() {
        if (!JavaAppDeployer.isNullOrEmpty(this.warFile)) {
            if (!this.fileExists(this.warFile)) {
                if (!JavaAppDeployer.isNullOrEmpty(this.warUrl)) {
                    try {
                        this.downloadFile(this.warUrl, new File(this.appPhysicalPath, this.warFile));
                    }
                    catch (Exception e) {
                        System.err.println("Download war file error: " + e.toString());
                        e.printStackTrace(System.err);
                    }
                }
            } else {
                System.out.println("war file " + this.warFile + " already exists");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String sourceUrl, File file) throws IOException {
        this.resetProgress();
        System.out.println("Downloading " + sourceUrl);
        BufferedInputStream in = null;
        FileOutputStream fOut = null;
        int bufferSize = 0x100000;
        int total = 0;
        try {
            int count;
            URL url = new URL(sourceUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(true);
            in = new BufferedInputStream(url.openStream());
            fOut = new FileOutputStream(file);
            byte[] data = new byte[bufferSize];
            while ((count = in.read(data, 0, bufferSize)) != -1) {
                fOut.write(data, 0, count);
                this.printProgress(total += count);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fOut != null) {
                fOut.close();
            }
        }
        System.out.printf("\nDownloaded %.1f Mb\n", (double)total / 1024.0 / 1024.0);
        System.out.printf("Saved to " + file.getAbsolutePath(), new Object[0]);
        System.out.print("\nApplication is starting, please wait...");
    }

    private void resetProgress() {
        this.lastProgressPrint = 0;
    }

    private void printProgress(int bytesDownloaded) {
        int delta_dots = (bytesDownloaded - this.lastProgressPrint * 0x100000) / 0x100000;
        if (delta_dots > 0) {
            for (int i = 0; i < delta_dots; ++i) {
                System.out.print(".");
                ++this.lastProgressPrint;
                if (this.lastProgressPrint % 10 == 0) {
                    System.out.printf(" %d Mb\n", bytesDownloaded / 1024 / 1024);
                }
                System.out.flush();
            }
        }
    }

    private boolean fileExists(String pathInApp) {
        File file = new File(this.appPhysicalPath, pathInApp);
        return file.exists();
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

