# NOTE!
# Helicon Zoo module runs this script every time IIS application pool recycles.
# This has several reasons:
#   1. you may not have ability to run required commands yourself (on a shared hosting, for example);
#   2. specific URL for deployment may cause security issues;
#   3. application pool doesn't recycle often.
#
# If you're sure you don't need this file, it can be removed.

require 'rbconfig'
require 'rubygems'
require 'open-uri'
require 'fileutils'
require 'openssl'


OpenSSL::SSL::VERIFY_PEER = OpenSSL::SSL::VERIFY_NONE



class Deploy
  APP_ROOT = File.dirname( __FILE__ )

  def initialize
    STDOUT.sync = true
    Dir.chdir( APP_ROOT )
  end

  def do!
     system_or_die('gem install execjs --no-ri --no-rdoc')
     system_or_die('gem install refinerycms --no-ri --no-rdoc')

     if ( !File.exist?("#{APP_ROOT}\\gemfile") )
       system_or_die("refinerycms .")
     end

     system_or_die('gem install bundle')
     system_or_die('bundle install')
  end

def system_or_die(command)

  puts "...\r\n"
  puts ">" + command
  puts "...\r\n"


  if !system(command)
    exit(1)
  end
end

  def download_file (url, file_name)
    print "Downloading "
    puts url
    downloaded_bytes = 0
    downloaded_mega_bytes = 0

    open(file_name, 'wb'){|file| file << open(url, "Referer" => REFERER,  :progress_proc => lambda {|s|
      downloaded_bytes=s
      mega_bytes = downloaded_bytes / (1024*1024)

      if mega_bytes > downloaded_mega_bytes
        downloaded_mega_bytes = mega_bytes

        if (downloaded_mega_bytes % 10 == 0  )
          puts downloaded_mega_bytes + " Mb"
        else
          print '.'
        end

      end

      }).read
    }

    puts ""
    puts "Download complete " + (downloaded_bytes / (1024*1024)).to_s() + " Mb"
  end



  def unzip_file (file, destination)
    require 'zip/zip'
    puts "Unzip "
     puts file
     puts "...\r\n"

    Zip::ZipFile.open(file) { |zip_file|
     zip_file.each { |f|
       f_path=File.join(destination, f.name)
       FileUtils.mkdir_p(File.dirname(f_path))
       zip_file.extract(f, f_path) unless File.exist?(f_path)
     }
    }
  end


  def replace_in_file(file_name, src, dest)

    printf "Replacing in file '%s'\r\n", file_name
    puts "...\r\n"
    puts "src: " + src
    puts "...\r\n"
    puts "dest: " + dest
    puts "...\r\n"

    text = File.read(file_name)
    replace = text.gsub( src, dest )
    File.open(file_name, "w") {|file| file.puts replace}

    puts "Done\r\n"

  end

end

Deploy.new.do!