<?php

$SOURCE = "https://codeload.github.com/gothfox/Tiny-Tiny-RSS/zip/1.7.9";
$LOCAL = "Tiny-Tiny-RSS-1.7.9.zip";

function downloadFile ($url, $path) {

  $newfname = $path;
  $file = fopen ($url, "rb");
  if ($file) {
    $newf = fopen ($newfname, "wb");

    if ($newf)
    while(!feof($file)) {
      fwrite($newf, fread($file, 1024 * 8 ), 1024 * 8 );
    }
  }

  if ($file) {
    fclose($file);
  }

  if ($newf) {
    fclose($newf);
  }
}

function extractZip( $zipFile = '', $dirFromZip = '' )
{    
    define(DIRECTORY_SEPARATOR, '\\');

    $zipDir = dirname($zipFile).DIRECTORY_SEPARATOR;
    $zip = zip_open($zipFile);
    
    if (!is_resource($zip)) {
        die("zip_open error ".$zip);
    }

    if ($zip)
    {
        while ($zip_entry = zip_read($zip))
        {
            $completePath = $zipDir . dirname(zip_entry_name($zip_entry));
            $completeName = $zipDir . zip_entry_name($zip_entry);
            
            if (zip_entry_open($zip, $zip_entry, "r"))
            {
                if( preg_match( '#^' . $dirFromZip .'.*#', dirname(zip_entry_name($zip_entry)) ) )
                {
                    if ($fd = @fopen($completeName, 'w+'))
                    {
                        #print "fopen $completeName\n";
                        fwrite($fd, zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)));
                        fclose($fd);
                    }
                    else
                    {
                        // We think this was an empty directory
                        #print "mkdir $completeName\n";
                        mkdir($completeName, 0777);
                    }
                    zip_entry_close($zip_entry);
                }
            }
        }
        zip_close($zip);
    }
    return true;
}


# download file
if (file_exists($LOCAL)){
  print $LOCAL." already downloaded\n";
  flush();
}
else {
  print "Downloading $SOURCE\n";
  flush();
  downloadFile($SOURCE, $LOCAL);
}

# extract zip
print "Extracting zip...\n";
flush();
extractZip($LOCAL);

# move from Tiny-Tiny-RSS-1.7.9 folder
shell_exec("xcopy /E /Q /Y Tiny-Tiny-RSS-1.7.9\\* .\\");
shell_exec("rmdir Tiny-Tiny-RSS-1.7.9 /s /q");

print "Tiny Tiny RSS successfully deployed\n";
flush();

sleep(1);

?>