<?php

$SOURCE = "http://sourceforge.net/projects/webim/files/Mibew%20Messenger/1.6.4/mibew164.zip/download";
$LOCAL = "mibew164.zip";

function downloadFile ($url, $path) {

  $newfname = $path;
  $file = fopen ($url, "rb");
  if ($file) {
    $newf = fopen ($newfname, "wb");

    if ($newf)
    while(!feof($file)) {
      fwrite($newf, fread($file, 1024 * 8 ), 1024 * 8 );
    }
  }

  if ($file) {
    fclose($file);
  }

  if ($newf) {
    fclose($newf);
  }
}

function extractZip( $zipFile = '', $dirFromZip = '' )
{    
    define(DIRECTORY_SEPARATOR, '\\');

    $zipDir = dirname($zipFile).DIRECTORY_SEPARATOR;
    $zip = zip_open($zipFile);
    
    if (!is_resource($zip)) {
        die("zip_open error ".$zip);
    }

    if ($zip)
    {
        while ($zip_entry = zip_read($zip))
        {
            $completePath = $zipDir . dirname(zip_entry_name($zip_entry));
            $completeName = $zipDir . zip_entry_name($zip_entry);
            
            if (zip_entry_open($zip, $zip_entry, "r"))
            {
                if( preg_match( '#^' . $dirFromZip .'.*#', dirname(zip_entry_name($zip_entry)) ) )
                {
                    if ($fd = @fopen($completeName, 'w+'))
                    {
                        #print "fopen $completeName\n";
                        fwrite($fd, zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)));
                        fclose($fd);
                    }
                    else
                    {
                        // We think this was an empty directory
                        #print "mkdir $completeName\n";
                        mkdir($completeName, 0777);
                    }
                    zip_entry_close($zip_entry);
                }
            }
        }
        zip_close($zip);
    }
    return true;
}


# download file
if (file_exists($LOCAL)){
  print $LOCAL." already downloaded\n";
  flush();
}
else {
  print "Downloading $SOURCE\n";
  flush();
  downloadFile($SOURCE, $LOCAL);
}

# extract zip
print "Extracting zip...\n";
flush();
extractZip($LOCAL);


# import parameters
require '_parameters';

# load config.php
$conf = file_get_contents("libs/config.php");

# make replacements
$conf = preg_replace("#webimroot\s*=\s*\"[^\"]*\";#",  "webimroot = \"".getenv("APPL_VIRTUAL_PATH")."\";", $conf);
$conf = preg_replace("#mysqlhost\s*=\s*\"[^\"]*\";#",  "mysqlhost = \"".$mysqlhost."\";", $conf);
$conf = preg_replace("#mysqldb\s*=\s*\"[^\"]*\";#",    "mysqldb = \"".$mysqldb."\";", $conf);
$conf = preg_replace("#mysqllogin\s*=\s*\"[^\"]*\";#", "mysqllogin = \"".$mysqllogin."\";", $conf);
$conf = preg_replace("#mysqlpass\s*=\s*\"[^\"]*\";#",  "mysqlpass = \"".$mysqlpass."\";", $conf);

# save config.php
file_put_contents("libs/config.php", $conf);

print "mibew messenger successfully deployed\n";
flush();

sleep(1);

?>