# -*- coding: utf-8 -*-

import re

from django.utils.encoding import smart_unicode
from forum.models.user import User

def find_best_match_in_name(content,  uname,  fullname,  start_index):      
    uname = smart_unicode(uname)
    fullname = smart_unicode(fullname)

    end_index = start_index + len(fullname)
    
    while end_index > start_index:
        if content[start_index : end_index].lower() == fullname.lower():
            return content[start_index : end_index]
            
        while len(fullname) and fullname[-1] != ' ':
            fullname = fullname[:-1]
            
        fullname = fullname.rstrip()
        end_index = start_index + len(fullname)
            
    return uname    

APPEAL_PATTERN = re.compile(r'(?<!\w)@\w+', re.UNICODE)

def auto_user_link(node, content):

    active_users = node.absolute_parent.get_active_users()
    
    appeals = APPEAL_PATTERN.finditer(content)

    replacements = []

    for appeal in appeals:
        # Try to find the profile URL
        username = smart_unicode(appeal.group(0)[1:])
        
        matches = []
        
        for user in active_users:
            if smart_unicode(user.username).lower().startswith(username.lower()):
                matches.append(user)
                
        if len(matches) == 1:
            replacements.append(
                                (find_best_match_in_name(content,  username, smart_unicode(matches[0].username),  appeal.start(0) + 1),  matches[0])
                                )                                
        elif len(matches) == 0:
            matches = User.objects.filter(username__istartswith=username)
            
        if (len(matches) == 0):
                continue
        
        best_user_match = None
        final_match = ""
        
        for user in matches:
            user_match = find_best_match_in_name(content,  username,  smart_unicode(user.username),  appeal.start(0) + 1)
            
            if (len(user_match) < len(final_match)): 
                continue
                
            if (len(user_match) == len(final_match)):
                if not (smart_unicode(user.username).lower() == user_match.lower()):
                    continue
                    
                if (best_user_match and (smart_unicode(best_user_match.username) == final_match)):
                    continue
                    
            best_user_match = user
            final_match = user_match
        
        replacements.append((final_match,  best_user_match))            
    
    for replacement in replacements:
        to_replace = "@" + smart_unicode(replacement[0])
        profile_url = replacement[1].get_absolute_url()
        
        auto_link = '<a href="%s">%s</a>' % (profile_url, to_replace)
        content = content.replace(to_replace, auto_link)        
    
    return content
