<?php

$SOURCE = "http://sourceforge.net/projects/roundcubemail/files/roundcubemail/0.8.4/roundcubemail-0.8.4.tar.gz/download";
$LOCAL = "temp\\roundcubemail-0.8.4.tar.gz";
$EXTRACTED = "temp\\roundcubemail-0.8.4";

function downloadFile ($url, $path) {

  $newfname = $path;
  $file = fopen ($url, "rb");
  if ($file) {
    $newf = fopen ($newfname, "wb");

    if ($newf)
    while(!feof($file)) {
      fwrite($newf, fread($file, 1024 * 8 ), 1024 * 8 );
    }
  }

  if ($file) {
    fclose($file);
  }

  if ($newf) {
    fclose($newf);
  }
}

# download file
if (file_exists($LOCAL)){
  print $LOCAL." already downloaded\n";
  flush();
}
else {
  print "Downloading $SOURCE\n";
  flush();
  downloadFile($SOURCE, $LOCAL);
}

# extract zip
print "Extracting zip...\n";
flush();
$phar = new PharData($LOCAL);
$phar->extractTo('temp', null, true);

# move files to root
print "Copying files from temp...\n";
flush();
system("xcopy /e /q /y $EXTRACTED\\* .\\");

print "Create config files from templates...\n";
flush();
system("copy /y config\\db.inc.php.dist config\\db.inc.php");
system("copy /y config\\main.inc.php.dist config\\main.inc.php");


print "Update configuration...\n";
flush();

# import parameters
require '_parameters';

# load
$conf = file_get_contents("config\\db.inc.php");

# make replacements
$conf = preg_replace(
  "#rcmail_config\['db_dsnw'\]\s*=\s*'mysql[^']+';#",  
  "rcmail_config['db_dsnw'] = 'mysql://$mysqllogin:$mysqlpass@$mysqlhost/$mysqldb';",
  $conf
);

# save
file_put_contents("config\\db.inc.php", $conf);


# $rcmail_config['enable_installer'] = false;

# load
$conf = file_get_contents("config\\main.inc.php");

# make replacements
$conf = preg_replace(
  "#rcmail_config\['enable_installer'\]\s*=\s*[^;]+;#",  
  "rcmail_config['enable_installer'] = true;",
  $conf
);
$conf = preg_replace(
  "#rcmail_config\['support_url'\]\s*=\s*[^;]+;#",  
  "rcmail_config['support_url'] = 'http://www.exmaple.com/';",
  $conf
);


# save
file_put_contents("config\\main.inc.php", $conf);


print "RoundCudeMail successfully deployed\n";
flush();

sleep(1);

?>